/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.region;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.gl.arena.GlBufferArena;
import net.caffeinemc.mods.sodium.client.gl.arena.PendingUpload;
import net.caffeinemc.mods.sodium.client.gl.arena.staging.FallbackStagingBuffer;
import net.caffeinemc.mods.sodium.client.gl.arena.staging.MappedStagingBuffer;
import net.caffeinemc.mods.sodium.client.gl.arena.staging.StagingBuffer;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.BuilderTaskOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkSortOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import net.caffeinemc.mods.sodium.client.render.chunk.data.SectionRenderDataStorage;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.SharedIndexSorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.Sorter;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import net.minecraft.class_10209;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import org.jspecify.annotations.NonNull;

public class RenderRegionManager {
    private final Long2ReferenceOpenHashMap<RenderRegion> regions = new Long2ReferenceOpenHashMap();
    private final StagingBuffer stagingBuffer;

    public RenderRegionManager(CommandList commandList) {
        this.stagingBuffer = RenderRegionManager.createStagingBuffer(commandList);
    }

    public void update() {
        this.stagingBuffer.flip();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            ObjectIterator it = this.regions.values().iterator();
            while (it.hasNext()) {
                RenderRegion region = (RenderRegion)it.next();
                region.update(commandList);
                if (!region.isEmpty()) continue;
                region.delete(commandList);
                it.remove();
            }
        }
    }

    public void uploadResults(CommandList commandList, Collection<BuilderTaskOutput> results) {
        for (Reference2ReferenceMap.Entry entry : this.createMeshUploadQueues(results)) {
            this.uploadResults(commandList, (RenderRegion)entry.getKey(), (Collection)entry.getValue());
        }
    }

    private void uploadResults(CommandList commandList, RenderRegion region, Collection<BuilderTaskOutput> results) {
        boolean needsSharedIndexUpdate;
        ArrayList<PendingSectionMeshUpload> uploads = new ArrayList<PendingSectionMeshUpload>();
        ArrayList<PendingSectionIndexBufferUpload> indexUploads = new ArrayList<PendingSectionIndexBufferUpload>();
        for (BuilderTaskOutput result : results) {
            NativeBuffer buffer;
            ChunkSortOutput indexDataOutput;
            int renderSectionIndex = result.render.getSectionIndex();
            if (result.render.isDisposed()) {
                throw new IllegalStateException("Render section is disposed");
            }
            if (result instanceof ChunkBuildOutput) {
                ChunkBuildOutput chunkBuildOutput = (ChunkBuildOutput)result;
                for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
                    SectionRenderDataStorage storage = region.getStorage(pass);
                    if (storage != null) {
                        storage.removeVertexData(renderSectionIndex);
                        region.clearCachedBatchFor(pass);
                    }
                    BuiltSectionMeshParts builtSectionMeshParts = chunkBuildOutput.getMesh(pass);
                    int meshTime = -1;
                    if (!result.render.isBuilt()) {
                        meshTime = Math.toIntExact(System.currentTimeMillis() - region.getCreationTime());
                    }
                    if (builtSectionMeshParts == null) continue;
                    uploads.add(new PendingSectionMeshUpload(result.render, meshTime, builtSectionMeshParts, pass, new PendingUpload(builtSectionMeshParts.getVertexData())));
                }
            }
            if (!(result instanceof ChunkSortOutput) || (indexDataOutput = (ChunkSortOutput)result).isReusingUploadedIndexData()) continue;
            Sorter sorter = indexDataOutput.getSorter();
            if (sorter instanceof SharedIndexSorter) {
                SharedIndexSorter sharedIndexSorter = (SharedIndexSorter)sorter;
                SectionRenderDataStorage storage = region.createStorage(DefaultTerrainRenderPasses.TRANSLUCENT);
                storage.removeIndexData(renderSectionIndex);
                if (!storage.setSharedIndexUsage(renderSectionIndex, sharedIndexSorter.quadCount())) continue;
                region.clearCachedBatchFor(DefaultTerrainRenderPasses.TRANSLUCENT);
                continue;
            }
            SectionRenderDataStorage storage = region.getStorage(DefaultTerrainRenderPasses.TRANSLUCENT);
            if (storage != null) {
                storage.removeIndexData(renderSectionIndex);
                storage.setSharedIndexUsage(renderSectionIndex, 0);
                region.clearCachedBatchFor(DefaultTerrainRenderPasses.TRANSLUCENT);
            }
            if (sorter == null || (buffer = sorter.getIndexBuffer()) == null) continue;
            indexUploads.add(new PendingSectionIndexBufferUpload(result.render, new PendingUpload(buffer)));
        }
        class_3695 profiler = class_10209.method_64146();
        SectionRenderDataStorage translucentStorage = region.getStorage(DefaultTerrainRenderPasses.TRANSLUCENT);
        boolean bl = needsSharedIndexUpdate = translucentStorage != null && translucentStorage.needsSharedIndexUpdate();
        if (uploads.isEmpty() && indexUploads.isEmpty() && !needsSharedIndexUpdate) {
            return;
        }
        class_243 cameraPosition = class_310.method_1551().field_1773.method_19418().method_71156();
        RenderRegion.DeviceResources resources = region.createResources(commandList);
        float regionFillFractionInv = region.getFillFractionInv();
        profiler.method_15396("upload_vertices");
        if (!uploads.isEmpty()) {
            GlBufferArena arena = resources.getGeometryArena();
            boolean bufferChanged = arena.upload(commandList, uploads.stream().map(upload -> upload.vertexUpload), regionFillFractionInv);
            if (bufferChanged) {
                region.refreshTesselation(commandList);
                region.clearAllCachedBatches();
            }
            for (PendingSectionMeshUpload pendingSectionMeshUpload : uploads) {
                SectionRenderDataStorage storage = region.createStorage(pendingSectionMeshUpload.pass);
                if (pendingSectionMeshUpload.relativeBuiltTime != -1) {
                    double dz;
                    double dy;
                    double dx = (double)pendingSectionMeshUpload.section.getCenterX() - cameraPosition.field_1352;
                    double distanceToPlayer = dx * dx + (dy = (double)pendingSectionMeshUpload.section.getCenterY() - cameraPosition.field_1351) * dy + (dz = (double)pendingSectionMeshUpload.section.getCenterZ() - cameraPosition.field_1350) * dz;
                    int relativeBuiltTime = distanceToPlayer < 768.0 ? -1 : pendingSectionMeshUpload.relativeBuiltTime;
                    pendingSectionMeshUpload.section.setFadeTime(relativeBuiltTime);
                    resources.writeMeshTimes(pendingSectionMeshUpload.section.getSectionIndex(), relativeBuiltTime);
                }
                storage.setVertexData(pendingSectionMeshUpload.section.getSectionIndex(), pendingSectionMeshUpload.vertexUpload.getResult(), pendingSectionMeshUpload.meshData.getVertexSegments());
            }
        }
        profiler.method_15405("upload_indices");
        boolean indexBufferChanged = false;
        if (!indexUploads.isEmpty()) {
            GlBufferArena arena = resources.getIndexArena();
            indexBufferChanged = arena.upload(commandList, indexUploads.stream().map(upload -> upload.indexBufferUpload), regionFillFractionInv);
            for (PendingSectionIndexBufferUpload pendingSectionIndexBufferUpload : indexUploads) {
                SectionRenderDataStorage storage = region.createStorage(DefaultTerrainRenderPasses.TRANSLUCENT);
                storage.setIndexData(pendingSectionIndexBufferUpload.section.getSectionIndex(), pendingSectionIndexBufferUpload.indexBufferUpload.getResult());
            }
        }
        if (needsSharedIndexUpdate) {
            indexBufferChanged |= translucentStorage.updateSharedIndexData(commandList, resources.getIndexArena(), regionFillFractionInv);
        }
        if (indexBufferChanged) {
            region.refreshIndexedTesselation(commandList);
            region.clearCachedBatchFor(DefaultTerrainRenderPasses.TRANSLUCENT);
        }
        profiler.method_15407();
    }

    private Reference2ReferenceMap.FastEntrySet<RenderRegion, List<BuilderTaskOutput>> createMeshUploadQueues(Collection<BuilderTaskOutput> results) {
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        for (BuilderTaskOutput result : results) {
            List queue = (List)map.computeIfAbsent((Object)result.render.getRegion(), k -> new ArrayList());
            queue.add(result);
        }
        return map.reference2ReferenceEntrySet();
    }

    public void delete(CommandList commandList) {
        for (RenderRegion region : this.regions.values()) {
            region.delete(commandList);
        }
        this.regions.clear();
        this.stagingBuffer.delete(commandList);
    }

    public Collection<RenderRegion> getLoadedRegions() {
        return this.regions.values();
    }

    public StagingBuffer getStagingBuffer() {
        return this.stagingBuffer;
    }

    public RenderRegion createForChunk(int chunkX, int chunkY, int chunkZ) {
        return this.create(chunkX >> RenderRegion.REGION_WIDTH_SH, chunkY >> RenderRegion.REGION_HEIGHT_SH, chunkZ >> RenderRegion.REGION_LENGTH_SH);
    }

    private @NonNull RenderRegion create(int x, int y, int z) {
        long key = RenderRegion.key(x, y, z);
        RenderRegion instance = (RenderRegion)this.regions.get(key);
        if (instance == null) {
            instance = new RenderRegion(x, y, z, this.stagingBuffer);
            this.regions.put(key, (Object)instance);
        }
        return instance;
    }

    private static StagingBuffer createStagingBuffer(CommandList commandList) {
        if (SodiumClientMod.options().advanced.useAdvancedStagingBuffers && MappedStagingBuffer.isSupported(RenderDevice.INSTANCE)) {
            return new MappedStagingBuffer(commandList);
        }
        return new FallbackStagingBuffer(commandList);
    }

    private record PendingSectionMeshUpload(RenderSection section, int relativeBuiltTime, BuiltSectionMeshParts meshData, TerrainRenderPass pass, PendingUpload vertexUpload) {
    }

    private record PendingSectionIndexBufferUpload(RenderSection section, PendingUpload indexBufferUpload) {
    }
}

